/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.toolkit;

import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.resources.VWResource;
import filenet.vw.base.logging.Level;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Locale;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

public class VWTaskLoggingPanel
extends VWTaskTabPanel
implements ActionListener {
    String m_logFileName = null;
    File m_logDirectory = null;
    JTextField m_loggingFile = null;
    JComboBox m_loggingLevel = null;
    JButton m_folderButton = null;
    JFileChooser m_fileDialog = null;

    public VWTaskLoggingPanel() {
        this.initLayout();
    }

    public VWTaskLoggingPanel(String logPath, Level logLevel) {
        this.initLayout();
        this.setLogPath(logPath);
        this.setLogLevel(logLevel);
    }

    public String getLogPath() {
        return this.m_loggingFile.getText().trim();
    }

    public void setLogPath(String logPath) {
        File logFile = new File(logPath);
        if (logFile.isDirectory() || logFile.getName().equals("")) {
            throw new IllegalArgumentException("Unable to determine the log file name from the log path. Log path: " + logPath);
        }
        this.m_logFileName = logFile.getName();
        this.setLogDirectory(logFile.getParentFile());
    }

    public Level getLogLevel() {
        String level = (String)this.m_loggingLevel.getSelectedItem();
        if (level.equals(VWResource.Error)) {
            return Level.SEVERE;
        }
        if (level.equals(VWResource.Warning)) {
            return Level.WARNING;
        }
        if (level.equals(VWResource.Information)) {
            return Level.INFO;
        }
        if (level.equals(VWResource.DetailedInformation)) {
            return Level.FINEST;
        }
        return Level.OFF;
    }

    public void setLogLevel(Level level) {
        if (level.equals(Level.SEVERE)) {
            this.m_loggingLevel.setSelectedItem(VWResource.Error);
        } else if (level.equals(Level.WARNING)) {
            this.m_loggingLevel.setSelectedItem(VWResource.Warning);
        } else if (level.equals(Level.INFO)) {
            this.m_loggingLevel.setSelectedItem(VWResource.Information);
        } else if (level.equals(Level.ALL) || level.equals(Level.FINE) || level.equals(Level.FINER) || level.equals(Level.FINEST)) {
            this.m_loggingLevel.setSelectedItem(VWResource.DetailedInformation);
        }
    }

    public void setEnabled(boolean enabled) {
        if (!VWTaskCore.getInstance().isAutoMode()) {
            this.m_loggingLevel.setEnabled(enabled);
            this.m_folderButton.setEnabled(enabled);
        }
    }

    public void actionPerformed(ActionEvent event) {
        String actionCMD = event.getActionCommand();
        Object aObj = event.getSource();
        try {
            File selected;
            if (this.m_fileDialog == null) {
                this.m_fileDialog = new JFileChooser(new File(this.getLogPath()).getParentFile());
                this.m_fileDialog.setFileSelectionMode(1);
                this.m_fileDialog.setApproveButtonText(VWResource.Select);
                this.m_fileDialog.setDialogTitle(VWResource.SelectADirectory);
            }
            if (this.m_fileDialog.showOpenDialog(this) == 0 && (selected = this.m_fileDialog.getSelectedFile()) != null) {
                this.setLogDirectory(selected);
                this.taskPropertyChanged(VWResource.LogFile);
            }
        }
        catch (Exception ex) {
            VWTaskCore.getInstance().displayError(ex);
        }
    }

    private void setLogDirectory(File directory) {
        this.m_logDirectory = directory;
        String dirPath = this.m_logDirectory.getAbsolutePath();
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        this.m_loggingFile.setText(dirPath + this.m_logFileName);
    }

    private void initLayout() {
        this.m_loggingFile = new JTextField();
        this.m_loggingFile.addFocusListener(this);
        Vector<String> loggingLevels = new Vector<String>();
        loggingLevels.add(VWResource.Error);
        loggingLevels.add(VWResource.Warning);
        loggingLevels.add(VWResource.Information);
        loggingLevels.add(VWResource.DetailedInformation);
        this.m_loggingLevel = new JComboBox(loggingLevels);
        this.m_loggingLevel.setRenderer(new LocalListCellRenderer());
        if (!VWTaskCore.getInstance().isAutoMode()) {
            VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
            VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.Logging, 0, panel);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 2;
            c.gridwidth = 1;
            c.insets = new Insets(10, 10, 0, 0);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            ++c.gridy;
            this.m_loggingFile.setEditable(false);
            panel.add((Component)new JLabel(VWResource.LogFile + ":"), c);
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridx = 1;
            panel.add((JTextComponent)this.m_loggingFile, (Object)c, false);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 2;
            c.insets = new Insets(10, 5, 0, 5);
            this.m_folderButton = VWImageLoader.createIconButton("folder.gif", VWResource.SelectLogFileLocation);
            this.m_folderButton.addActionListener(this);
            panel.add((Component)this.m_folderButton, c);
            c.insets = new Insets(10, 10, 0, 5);
            c.weighty = 0.0;
            c.weightx = 0.0;
            c.gridx = 0;
            ++c.gridy;
            panel.add((Component)new JLabel(VWResource.LoggingLevel + ":"), c);
            c.weighty = 0.0;
            c.weightx = 1.0;
            c.gridx = 1;
            panel.add((Component)this.m_loggingLevel, c);
            c.insets = new Insets(0, 0, 0, 0);
            c.weighty = 1.0;
            c.weightx = 1.0;
            c.gridx = 0;
            c.gridwidth = 2;
            ++c.gridy;
            panel.add(Box.createHorizontalStrut(0), c);
            this.setLayout(new BorderLayout());
            this.add((Component)borderPanel, "Center");
        }
    }

    public class LocalListCellRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
            this.setComponentOrientation(compOrientation);
            return this;
        }
    }
}

